global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_1_4Prop")
local handlestate

handlestate = 0

-- Handbrake

global function AnimDone()
	local anim 
	local ce7 = FindNodeByName("ce7")
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_Time_Handbrake_Anim_TARDIS_Interior")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Time_Handbrake_Anim_Handbrake_down_Idle")
		ce7:Trigger()
	end

	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_Time_Handbrake_Anim_Handbrake_down")

	handlestate = 1

	FindNodeByName("Ob1_4SoundDown"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_Time_Handbrake_Anim_Handbrake_Up")

	handlestate = 0

	FindNodeByName("Ob1_4SoundUp"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	controls.script.TurnOffInterface()
	
	if (handlestate == 0) then
		PlayDown()
	else
		PlayUp()
	end
	
	FindNodeByName("Console1InteractableScript").script.Object4State = handlestate

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2484:Time Rotor Handbrake: Immediately stops the TARDIS from travelling through time. Unless you're going too fast, then you'll skid for a bit. Er, apparently...
		else
			--VO Console Control Text
			amy::SID_2485:This has to be the handbrake, it looks like one anyway. Only one way to find out.
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim

	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_Time_Handbrake_Anim_Handbrake_down_Idle")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Time_Handbrake_Anim_Handbrake_Up")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	handlestate = 0
end
